/**

VIDEO ANALYSIS PREPROCESSING  - MODULES
author: Pavel Zak, izakpa@fit.vutbr.cz

Each module does specific image operation. The abstract factory design enables extension with new modules that perform additional tasks.
In that case, you need to:
1) inherit the basic module class and implement process() method.
2) add new IF statement in the module factory method getPreproc_Module().

*/
#include "preprocModules.h"

using namespace std;



Preproc_module::Preproc_module(string proc_type, map<string, string> parameters, string queue){
  next.clear();
	//params.clear();
	result = NULL;
	//params = parameters;
	qid = queue;
	inited = true;
	
	typ = proc_type;
	timestamp = 0;
	//todo - kontrola korektnosti parametru - v konkretni tride
}

Preproc_module::~Preproc_module(){
	for (unsigned int i=0; i<next.size(); i++){
		delete next[i];
	}
	next.clear();
	//params.clear();
	if (result) cvReleaseImage(&result);
}

bool Preproc_module::isOK(){
	return inited;
}

string Preproc_module::getQid(){
	return qid;
}

IplImage * Preproc_module::getResult(){
	return result;
}

int64 Preproc_module::getTimeStamp(){
	return timestamp;
}

void Preproc_module::add_next(Preproc_module * module){
	next.push_back(module);
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

Preproc_module * Preproc_ModuleFactory::getPreproc_Module(string type, map<string, string> parameters, string queue){
	if (type=="NSKIP"){
		return new Preproc_nskip(type, parameters, queue);
	}
	else if (type=="CROP"){
		return new Preproc_crop(type, parameters, queue);
	}
	else if (type=="RESIZE"){
		return new Preproc_resize(type, parameters, queue);
	}
	else if (type=="CONVERT"){
		return new Preproc_convert(type, parameters, queue);
	}
	else if (type=="SOURCE"){
		return new Preproc_source(type, parameters, queue);
	}
	else return NULL;
}

///////////////////////////////////////////////////////////

Preproc_resize::Preproc_resize(string type, map<string, string> parameters, string queue)
: Preproc_module(type, parameters, queue) {
	//ToDo test parametru
	width = atoi(parameters["WIDTH"].c_str());
	height = atoi(parameters["HEIGHT"].c_str());

}

int Preproc_resize::process(IplImage * image, int64 frameNo, string sourceID){
	timestamp = frameNo;

	if (!result)
		result  = cvCreateImage(cvSize(width, height), image->depth, image->nChannels);
	cvResize(image, result);

	for (unsigned int i=0; i<next.size(); i++){
			next[i]->process(result, frameNo, sourceID);
		}
	return 1;
}
///////////////////////////////////////////////////////////

Preproc_crop::Preproc_crop(string type, map<string, string> parameters, string queue)
: Preproc_module(type, parameters, queue) {
	//ToDo
	width = atoi(parameters["RIGHT"].c_str())-atoi(parameters["LEFT"].c_str());
	height = atoi(parameters["BOTTOM"].c_str())-atoi(parameters["TOP"].c_str());
	left = atoi(parameters["LEFT"].c_str());
	top = atoi(parameters["TOP"].c_str());
}
int Preproc_crop::process(IplImage * image, int64 frameNo, string sourceID){
	timestamp = frameNo;

	if (!result)
		result  = cvCreateImage(cvSize(width, height), image->depth, image->nChannels);

	cvSetImageROI(image, cvRect(left, top, width, height));
	cvCopy(image, result);
	cvResetImageROI(image);

	for (unsigned int i=0; i<next.size(); i++){
			next[i]->process(result, frameNo, sourceID);
		}
	return 1;
}

///////////////////////////////////////////////////////////

Preproc_nskip::Preproc_nskip(string type, map<string, string> parameters, string queue)
: Preproc_module(type, parameters, queue){
	firstcall = true;
	lastNo = 0;
	frameskip = atoi(parameters["FRAMES"].c_str());
	//ToDo
}
int Preproc_nskip::process(IplImage * image, int64 frameNo, string sourceID){
	timestamp = frameNo;

	if (firstcall) {
		result = image;
		lastNo = frameNo; 
		firstcall = false;
	}
	else if ((frameNo-lastNo)>=frameskip){
		result = image;
		lastNo = frameNo;
	}
	else 
	result = NULL;

	for (unsigned int i=0; i<next.size(); i++){
			next[i]->process(result, frameNo, sourceID);
		}
	return 1;
}

///////////////////////////////////////////////////////////

Preproc_convert::Preproc_convert(string type, map<string, string> parameters, string queue)
: Preproc_module(type, parameters, queue){
	//ToDo
	from = parameters["FROM"];
	to = parameters["TO"];

	depth = 8;
	if ((to=="RGB")||(to=="BGR")||(to=="HSV"))channels = 3;
	else if (to=="GRAY") channels = 1;

	//ToDo vyber code a sestrojeni result;
	if (from=="RGB"){
		if (to=="HSV") code = CV_RGB2HSV;
		else if (to=="GRAY") code = CV_RGB2GRAY;
		else if (to=="BGR") code = CV_RGB2BGR;
		else inited = false;
	}
	else if (from=="BGR"){
		if (to=="HSV") code = CV_BGR2HSV;
		else if (to=="GRAY") code = CV_BGR2GRAY;
		else if (to=="RGB") code = CV_BGR2RGB;
		else inited = false;
	}
	else if (from=="HSV"){
		if (to=="RGB") code = CV_HSV2RGB;
		else if (to=="BGR") code = CV_HSV2BGR;
		else inited = false;
	}
	else if (from=="GRAY"){
		if (to=="RGB") code = CV_GRAY2RGB;
		else if (to=="BGR") code = CV_GRAY2BGR;
		else inited = false;
	}
	else{
		code = 0;
		inited = false;
	}
}

int Preproc_convert::process(IplImage * image, int64 frameNo, string sourceID){
	timestamp = frameNo;
	//result = image;
	//return 1;
	
	if (!result){
		result  = cvCreateImage(cvSize(image->width, image->height), depth, channels);
	}

	cvCvtColor(image, result, code);

	for (unsigned int i=0; i<next.size(); i++){
			next[i]->process(result, frameNo, sourceID);
		}
	return 1;
}

///////////////////////////////////////////////////////////

Preproc_source::Preproc_source(string type, map<string, string> parameters, string queue)
: Preproc_module(type, parameters, queue){
	//ToDo
	source = parameters["SOURCE"];
}

int Preproc_source::process(IplImage * image, int64 frameNo, string sourceID){
	timestamp = frameNo;
	if (source == sourceID){
		result = image;
		for (unsigned int i=0; i<next.size(); i++){
			next[i]->process(result, frameNo, sourceID);
		}
	}
	//else
	//result = NULL;

	
	return 1;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
